import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { mutationResponse } from "../../util/processResponse.js";

const initialState = {
    data: {},
    loading: false,
};

export const postSelectProduct = createAsyncThunk(
    "cart/postSelectProduct",
    async (params) => {
        const { access_token, selectURL, method, data } = params;
        const response = await mutationResponse(
            selectURL,
            method,
            data,
            access_token
        );
        return response;
    }
);

const postSelectProductSlice = createSlice({
    name: "cart",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(postSelectProduct.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(postSelectProduct.fulfilled, (state, { payload }) => {
            const { records, status } = payload || {};
            if (status?.code == 200) {
                state.data = records?.data;
            }
            state.loading = false;
        });
        builder.addCase(postSelectProduct.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default postSelectProductSlice.reducer;
